function [flowbackR] = segment_flowback(gray_bfr_flowbackR,mask_fpi,edge_wwf)

% Used to segment the flowback region from the illumination corrected region of interest consisting of
% the breech face region and flowback
%% input
% gray_bfr_flowbackR : firing pin impression removed illumination
%                      corrected, registered/unregistered region of interest. This region of
%                      interest consists of the breech face region and flowback
% mask_fpi : binarized mask of firing pin impression
% edge_wwf : The outermost continuous edge of the region of interest
%% output
% flowbackR : segmented flowback region 


% calculate the flowback region 
[r1 c1]=size(gray_bfr_flowbackR);
ZZ=double(gray_bfr_flowbackR)>= mean(double(gray_bfr_flowbackR(:)))+std(double(gray_bfr_flowbackR(:))); % threshold the flowback region
%ZZ=double(BFgn1)>= me_z + st_z; % threshold the flowback region %% This
%gave worse results
ZZ=bwmorph(ZZ,'clean');

[jX jY ]=find_logical(ZZ);
FBB=zeros(size(gray_bfr_flowbackR));

[xej yej ]=find_logical(edge_wwf);
% Find the largest connected component - not the largest but the ones that 
% are closer to FPI than the edge min(mean(distmat)) - will implement it on
% 2021/08/20

% edge FPI
FF2_e=edge(mask_fpi,'Sobel');
[xFF2 yFF2]=find_logical(FF2_e);
dis=[];
if isempty(jX)==0
    
    AS=bwlabel(ZZ,8);
    Re=regionprops(AS,'all');
%     Qn=cat(2,Re(:).Area);
    %[mx mxi1]=max(Qn);
    % find edge of each connected component
    dis=zeros([length(Re),1]); % if dis =1 means closer to FP else closer to edge
    for n=1:length(Re)
        Imn=zeros([r1 c1]);
        px=Re(n).PixelList;
        for r=1:length(px)
            Imn(px(r,2),px(r,1))=1;
        end
      Imn_e=edge(Imn,'Sobel');
      [x_e y_e]=find_logical(Imn_e);
      % distance between connected component + FPI
      d_ff2=zeros([length(x_e) length(xFF2)]);
      conC=[y_e x_e];
      fP=[yFF2 xFF2];
      ed=[yej xej];
      for a=1:size(conC,1)
          for b=1: size(fP,1)
              
              d_ff2(a,b)= sqrt(sum((conC(a,:)-fP(b,:)).^2,2));
              %d_ff2(a,b)=d_a;
          end
      end
       d_ff2_min=min(min(d_ff2,[],2));
      % distance between connected component + FPI
       d_edge=zeros([length(x_e) length(xej)]);
      for a=1:length(x_e)
          for b=1: length(xej)
          
            d_edge(a,b)=sqrt(sum((conC(a,:)-ed(b,:)).^2,2));
          end
      end
      d_edge_min=min(min(d_edge,[],2));
      
      if d_ff2_min<d_edge_min
          dis(n)=1;
      end
    end
end

ASE=zeros([r1 c1]);
AD=zeros([r1 c1]);
if isempty(dis)==0
  for u=1:length(dis)
     
      if dis(u)==1
         ds=Re(u).PixelList;
        for t=1:length(ds)
             AD(ds(t,2), ds(t,1))=1;
        end
      end
  end
end


ASE=AD+mask_fpi;
ASE=logical(imfill(ASE,'holes'));
 FBB=zeros(r1,c1);     

[xase yase]=find_logical(ASE);

EW1=zeros([r1 c1]);
FBB1=zeros([r1 c1]);
if isempty(xase)==0
      EQ=edge(ASE,'Sobel');
      [xxe yye]=find_logical(EQ);%Find all edge points of combined mask 
      Cv=[yye xxe];
          if isempty(Cv)==0
           [Xtt,a,b,c] = MinVolEllipse_U2(Cv', 0.01); % Fit a minimum volume ellipse to the sum
             if a>b
               se=strel('disk',round(a),0);
             else
               se=strel('disk',round(b),0);
             end
           Xtt=round(Xtt');
           Xtt(Xtt<=0)=1;
           for s=1:size(Xtt,1)
               EW1(Xtt(s,2),Xtt(s,1))=1;
           end
           FBB1=imclose(EW1,se);
           FBB=FBB1(1:r1,1:c1);
        else
           FBB=ASE;
        end
else
    FBB=mask_fpi; % Flowback +FPI mask
end

flowbackR=FBB;
se=strel('disk',6); % area inside
EJbwd=imdilate(edge_wwf,se);

[xbw ybw]=find_logical(EJbwd);
[xfn yfn]=find_logical(flowbackR);

EJbwf=imfill(edge_wwf,'holes');
[EJfx EJfy]=find_logical(logical(EJbwf)==0);
EJfc=[EJfy EJfx]; %  points in image outside cartridge case mask
xC=[EJfx;xbw];
yC=[EJfy;ybw];
% E_all=[ybw xbw;EJfc];
% B1=intersect([yfn xfn],[ybw xbw],'rows');
% B3=intersect([yfn xfn],[EJfy EJfx],'rows');
% B2=[B1;B3];
B2=intersectRows([yfn xfn],[yC xC]);
if isempty(B2)==0
    for u=1:size(B2,1)
        flowbackR(B2(u,2),B2(u,1))=0;
    end
end